package app.firezone.synk.network.Activities;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.database.FirebaseDatabase;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.databinding.ActivityWalletBinding;

import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.User;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class WalletActivity extends AppCompatActivity {


    ActivityWalletBinding binding;

    FirebaseDatabase database;

    private MyApi myApi;

    FirebaseUser auth;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding =  ActivityWalletBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        binding.backArrow.setOnClickListener(v -> finish());

        binding.addMoneyBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(WalletActivity.this, Add_Money_Activity.class));
            }
        });

        binding.withdrawMoneyBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(WalletActivity.this, RedeemActivity.class));
            }
        });


        binding.transactionHistoryCard.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(WalletActivity.this, TransactionHistoryActivity.class));
            }
        });

        binding.withdrawSavedCard.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(WalletActivity.this, WithdrawPaymentSavedActivity.class));
            }
        });

        binding.depositSavedCard.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(WalletActivity.this, DepositPaymentSavedActivity.class));
            }
        });


        long userId = SharedPrefManager.getInstance(WalletActivity.this).getUserId();
        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);

        Call<ApiResponse> calls = myApi.fetchProfileData(userId);

        calls.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = response.body().getUser();

                    double totalWinBal = model.getWinBalance();
                    double totalDepoBal = model.getDepoBalance();
                    double totalBonusBal = model.getBonusBalance();
                    String totalBal = String.valueOf(totalDepoBal + totalWinBal + totalBonusBal);

                    binding.balanceTxt.setText("₹"+totalBal);
                    binding.depoBalanceTxt.setText(String.valueOf("₹"+totalDepoBal));
                    binding.winBalanceTxt.setText(String.valueOf("₹"+totalWinBal));
                    binding.bonusBalanceTxt.setText(String.valueOf("₹"+totalBonusBal));
                } else {
                    Toast.makeText(WalletActivity.this, "Failed to fetch user data", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable throwable) {

            }
        });





    }
}